
#import "MeineFunktionen.h"
#import "C++.h"

extern "C"
{
	#import "C.h"
}

@implementation NSApplication (MeineFunktionen)

- (NSString *)ObjC_Funktion:(long)param
{
	// Objective-C kann man ohne Umschweife benutzen
	return [NSString stringWithFormat:@"Objective-C: Parameter ist %d.", param];
}

- (NSString *)C_Funktion:(long)param1 mit:(long)param2
{
	// C-Funktion getCResult() aufrufen
	// siehe C.h und C.c
	// param1 und param2 werden im Beispiel nicht benutzt
	NSString *result = [NSString stringWithCString:getCResult()];
	return result;
}

- (NSString *)CPlusPlus_Funktion
{
	// C++-Objekt CPlusPlusObject anlegen
	// siehe C++.h und C++.cpp
	CPlusPlusObject cppObject = CPlusPlusObject();
	
	// Die Methode result des Objekts CPlusPlusObject aufrufen
	NSString *result = [NSString stringWithCString: cppObject.result()];
	return result;
}

- (NSString *)Java_Funktion
{
	// Das Objective-C-Object jObject anlegen, das in
	// Java implementiert ist (siehe JavaObject.java)
	id jObject = [[[NSClassFromString(@"JavaObject") alloc] init] autorelease];
	
	// Das Ergebnis der Methode result zurckgeben
	return [jObject result];
}

@end